<?php
$contentPath = __DIR__ . '/data/content.json';
if (!is_file($contentPath)) {
  http_response_code(500);
  exit('Content file missing.');
}

$contentJson = file_get_contents($contentPath);
$content = json_decode($contentJson, true);
if (!is_array($content)) {
  http_response_code(500);
  exit('Invalid content configuration.');
}

function esc($value): string {
  return htmlspecialchars((string)($value ?? ''), ENT_QUOTES, 'UTF-8');
}

function raw_text($value): string {
  return (string)($value ?? '');
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= esc($content['engagement']['title'] ?? '') ?> - <?= esc($content['site']['title'] ?? '') ?></title>
  <meta name="description" content="<?= esc($content['engagement']['subtitle'] ?? '') ?>" />
  <meta name="theme-color" content="<?= esc($content['site']['theme_color'] ?? '') ?>" />

  <!-- Bootstrap 5 & Icons (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" />

  <!-- Font - Senatory style -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;800;900&family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet" />

  <link rel="stylesheet" href="/assets/styles.css" />
</head>
<body>
  <?php 
  // Inclure le menu principal
  $currentPage = 'pourquoi.php';
  include __DIR__ . '/menu.php';
  ?>

  <!-- Hero -->
  <section class="engagement-hero text-center">
    <div class="container">
      <h1><?= esc($content['engagement']['title'] ?? '') ?></h1>
      <p class="subtitle"><?= esc($content['engagement']['subtitle'] ?? '') ?></p>
    </div>
  </section>

  <!-- Sections principales -->
  <?php foreach (($content['engagement']['sections'] ?? []) as $section): ?>
    <section class="engagement-section">
      <div class="container">
        <h2><?= esc($section['title'] ?? '') ?></h2>
        <div class="content-text">
          <?php foreach (($section['content'] ?? []) as $paragraph): ?>
            <p><?= esc($paragraph) ?></p>
          <?php endforeach; ?>
        </div>
      </div>
    </section>
  <?php endforeach; ?>

  <!-- Boussoles -->
  <?php if (!empty($content['engagement']['boussoles'])): ?>
    <section class="engagement-section bg-cream">
      <div class="container">
        <h2 class="text-center w-100"><?= esc($content['engagement']['boussoles']['title'] ?? '') ?></h2>
        <div class="boussoles-grid">
          <?php foreach (($content['engagement']['boussoles']['items'] ?? []) as $index => $item): ?>
            <div class="boussole-card">
              <span class="boussole-number"><?= $index + 1 ?></span>
              <p class="boussole-text mb-0"><?= esc($item) ?></p>
            </div>
          <?php endforeach; ?>
        </div>
        <?php if (!empty($content['engagement']['boussoles_note'])): ?>
          <div class="content-text text-center mt-4">
            <p><em><?= esc($content['engagement']['boussoles_note']) ?></em></p>
          </div>
        <?php endif; ?>
      </div>
    </section>
  <?php endif; ?>

  <!-- Scoutisme promesse -->
  <?php if (!empty($content['engagement']['scoutisme_promesse'])): ?>
    <section class="engagement-section">
      <div class="container">
        <h2><?= esc($content['engagement']['scoutisme_promesse']['title'] ?? '') ?></h2>
        <div class="content-text">
          <?php foreach (($content['engagement']['scoutisme_promesse']['content'] ?? []) as $paragraph): ?>
            <p><?= esc($paragraph) ?></p>
          <?php endforeach; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <!-- Serment -->
  <?php if (!empty($content['engagement']['serment'])): ?>
    <section class="engagement-section bg-cream">
      <div class="container">
        <div class="serment-box">
          <h2><?= esc($content['engagement']['serment']['title'] ?? '') ?></h2>
          <?php foreach (($content['engagement']['serment']['content'] ?? []) as $paragraph): ?>
            <p><?= esc($paragraph) ?></p>
          <?php endforeach; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <!-- Dernier mot -->
  <?php if (!empty($content['engagement']['dernier_mot'])): ?>
    <section class="dernier-mot">
      <div class="container">
        <h2><?= esc($content['engagement']['dernier_mot']['title'] ?? '') ?></h2>
        <div class="content-text">
          <?php foreach (($content['engagement']['dernier_mot']['content'] ?? []) as $index => $paragraph): ?>
            <?php if ($index >= count($content['engagement']['dernier_mot']['content']) - 3): ?>
              <p class="mission-highlight"><?= esc($paragraph) ?></p>
            <?php else: ?>
              <p><?= esc($paragraph) ?></p>
            <?php endif; ?>
          <?php endforeach; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <!-- Footer -->
  <footer>
    <div class="container text-center">
      <div class="small">
        <?php
          $footerText = esc($content['footer']['copyright'] ?? '');
          $footerText = str_replace('%YEAR%', date('Y'), $footerText);
          echo $footerText;
        ?>
      </div>
      <div class="small mt-2"><?= esc($content['footer']['slogan'] ?? '') ?></div>
    </div>
  </footer>

  <!-- Back to top button -->
  <a href="index.php" class="btn btn-back" aria-label="Retour à l'accueil" title="Retour à l'accueil">
    <i class="bi bi-house-fill"></i>
  </a>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

